#ifndef _H_CWindow
#define _H_CWindow

#ifndef __GNUC__
	#include <Drag.h>
#endif

#include "Utils.h"

#ifndef ulong
	typedef	unsigned long	ulong;
	typedef	unsigned short	ushort;
#endif

typedef union {
	WindowRef	window;	//	same as GrafPtr
	DialogRef	dialog;	
} MacPort;

typedef enum {
	ADFS_Window_NONE, 
	
	ADFS_Window_WINDOW, 
		ADFS_Window_DIALOG, 
			ADFS_Window_MODELESS_DIALOG, 
				ADFS_Window_MDLG_GET_INFO, 
			ADFS_Window_MODAL_DIALOG, 
				ADFS_Window_NEW_DISK, 
				ADFS_Window_SECTOR_ORDER, 
		ADFS_Window_DOCUMENT, 
			ADFS_Window_PICTURE, 
			ADFS_Window_TEXT, 
			ADFS_Window_GENERATOR, 
			ADFS_Window_DISK_MAP, 
			ADFS_Window_OUTLINE, 
				ADFS_Window_FINDER, 
					ADFS_Window_DESKTOP, 
					ADFS_Window_FOLDER, 

	ADFS_Window_NUMTYPES
} ADFS_WindowType;

typedef enum {
	WindowRect_NONE, 
	
	WindowRect_ALL_GLOBAL, 
	WindowRect_ALL, 

		WindowRect_HEADER_DISK_INFO, 
		WindowRect_HEADER_STAT_INFO, 
	WindowRect_HEADER, 

	WindowRect_INTERIOR, //	all minus scrollbars, header
	WindowRect_H_SCROLL, 
	WindowRect_V_SCROLL,
	WindowRect_GROW_BOX, 
		 
	WindowRect_NUMTYPES
} WindowRectType;

extern	ADFS_FontRec	gFontRec;

#define	kCWindowMagic		'wndo'

class	CRenameTextEdit;
class 	CWindow;

typedef	OSErr	(*IterateDragFlavorsCB)(
	CWindow			*thiz, 
	DragReference	theDrag, 
	ItemReference	itemRef, 
	FlavorType		flavorType, 
	void			*data
);

class CWindow {

	public:	Boolean	IWindow(ADFS_WindowType windowType);
	virtual	void	Dispose(void);
	
	virtual	OSErr	Prepare(void);
	virtual	void	UnPrepare(void);

	virtual	void	SetPTitle(unsigned char *nameZu);
	virtual	void	SetTitle(char *nameZ);
	virtual	void	DoKeyDown(EventRecord *event);
	virtual	void	DoClick(EventRecord *event);
	virtual	void	ReActivate(Boolean active);
	virtual	void	Update(void);
	virtual	void	Draw(void);
	virtual	void	Idle(void);
	virtual	void	Move(EventRecord *event);
	virtual	Rect	GetSizeRect(void);
	virtual	void	SetSizeRect(Rect *sizeRect);
	virtual	void	Size(EventRecord *event);
	virtual	void	Zoom(EventRecord *event, short direction);
	virtual	Boolean	CanClose(void);
	virtual	Boolean	SectVisRgnWindowRect(WindowRectType windowRect, Rect *sectR = NULL);
	virtual	void	ShowHide(Boolean show);
	virtual	void	Show(Boolean show);
	virtual	void	GoAway(EventRecord *event);
	virtual	Boolean	DoCommand(long command);
	virtual	void	UpdateMenus(void);
	virtual	Boolean	IsShowing(void);

	virtual	void	InvalWindow(WindowRectType windowRect);
	virtual	void	SetFontInfo(void);
	virtual	void	UpdateFontInfo(ADFS_FontRec *fontRec);
	virtual	Rect	GetWindowRect(WindowRectType wrType);
	virtual	Boolean	IsFrontWindow(void);

	#ifndef __68k__
		typedef long	OSStatus;
		typedef long	WindowAttributes;
		
		virtual OSStatus	SetAttribute(WindowAttributes attribs);
		virtual	OSStatus	ClearAttribute(WindowAttributes attribs);
	#endif
	
	/********************/
	//	drag stuff
	
	virtual	OSErr	IterateDragFlavors(
		DragReference			theDrag, 
		IterateDragFlavorsCB	Iterate, 
		void					*data);

	virtual	OSErr	CanAcceptFlavor(
		DragReference	theDrag, 
		ItemReference	itemRef, 
		FlavorType		flavorType, 
		Boolean			*isGoodFlavorB);

	static	OSErr	CanAcceptFlavorCB(
		CWindow			*thiz, 
		DragReference	theDrag, 
		ItemReference	itemRef, 
		FlavorType		flavorType, 
		void			*data);

	virtual	OSErr	CanAcceptDrag(DragReference theDrag);
	
	virtual	OSErr	DragTrackInWindow(DragReference theDrag);
	
	static	pascal OSErr DragTrackCB(
		DragTrackingMessage		message, 
		WindowPtr				theWindow, 
		void					*data, 
		DragReference			theDrag
	);

	virtual		OSErr	DragTrack(
		DragTrackingMessage		message, 
		DragReference			theDrag
	);

	virtual	OSErr		DragHasFlavor(
		DragReference	theDrag, 
		FlavorType		flavorType, 
		ItemReference	*itemRefP);

	virtual	OSErr	DragReceiveFlavor(
		DragReference	theDrag, 
		ItemReference	itemRef, 
		FlavorType		flavorType, 
		void			*data
	);

	static	OSErr	DragReceiveFlavorCB(
		CWindow			*thiz, 
		DragReference	theDrag, 
		ItemReference	itemRef, 
		FlavorType		flavorType, 
		void			*data
	);
	
	static	pascal OSErr DragReceiveCB(
		WindowPtr				theWindow, 
		void					*data, 
		DragReference			theDrag
	);

	virtual		OSErr	DragReceive(
		DragReference			theDrag
	);

	virtual	void		SetWindowRect(Rect *r);

	virtual	GrafPtr		GetGrafPtr(void);
	virtual	WindowRef	GetWindowRef(void);
	void				Flush(void);

	virtual	Boolean		IsDirty(void);
	virtual	void		SetDirty(Boolean dirtyB);

	/*****************************************/
	
	#ifdef OLD68K
	Boolean				i_dirtyB;
	#endif
	
	CRenameTextEdit		*i_renameTE;
	Rect				i_sizeRect;
	ADFS_WindowType		i_windowType;	
	long				i_magic;

	Boolean				i_active;
	Boolean				i_invalid;
	MacPort				i_macPort;

	Boolean				i_trackInstalled;
	Boolean				i_receiveInstalled;
	Boolean				i_dragCanAccept;

	RgnHandle			i_frameRgn;
	RgnHandle			i_clipRgn;
	
	ADFS_FontRec		i_fontRec;
	FontInfo			i_fontInfo;
};

typedef Boolean		(*CWindowCB)(CWindow *window, void *data);
Boolean				IterateCWindows(CWindowCB cWindowCB, void *data);

CWindow		*GetCWindow(WindowRef windowRef);
CWindow		*GetFrontCWindow(void);

Boolean		CloseAllCWindows(void);
void		InvalAllCWindows(void);

#endif